/**
 * Represents a Human
 */
export class Human{
    /**
     * Represents a Human in the world
     * @param {string} name This Human's name
     * @param {string} fname This Human's family name
     * @param {Date} birthdate This Human's birthdate
     * @param {string|number} id This Human's identifier
     */
    constructor(name, fname, birthdate, id){
        /**
         * @type {string}
         * @description This Human's name
         */
        this.name = name;
        /**
         * @type {string}
         * @description This Human's family name
         */
        this.familyName = fname;
        /**
         * @type {Date}
         * @description This Human's birth date (first time log-on)
         */
        this.birthdate = birthdate;
        /**
         * @type {Array<string>}
         * @description Roles and groups this Human is part of
         */
        this.roles = [];
        /**
         * @type {string}
         * @description This Human's gender
         */
        this.gender = "";
        /**
         * @type {number|string}
         * @description This Human's unique identifier
         */
        this.identifier = id;
        /**
         * @type {number}
         * @description This Human's Human-Type (Human 0, Teacher 1, ...)
         */
        this.type = 0;

        /**
         * @type {boolean}
         * @description Is this Human married?
         */
        this.isMarried = false;
        /**
         * @type {Array<string|number>}
         * @description Humans (identifiers) who this Human loves
         */
        this.loves = [];
        /**
         * @type {Array<string|number>}
         * @description Humans (identifiers) who this Human hates
         */
        this.hates = [];
        /**
         * @type {Array<string|number>}
         * @description Humans (identifiers) who count as this Human's children
         */
        this.parentOf = [];
        /**
         * @type {Array<string|number>}
         * @description Humans (identifiers) who count as this Human's parents
         */
        this.childOf = [];
    };
    /**
     * Gets a string that can be loaded with Human.loadSveString()
     * @returns {string}
     */
    getSaveString(){
        let {...data} = this;
        return JSON.stringify(data);
    };
    /**
     * Loads all data from a string
     * @param {string} data String holding Human data
     */
    loadSaveString(data){
        Object.assign(this, JSON.parse(data));
    };
    /**
     * Creates a new Human from a Save String
     * @param {string} data String holding Human data
     * @returns {Human}
     */
    static newHumanFromString(data){
        let human = new Human("", "", Date(), "");
        human.loadSaveString(data);
        return human;
    };
};